---
description: Steps on how to deploy this GIS application to a production server
---

# Deployment Workflow

Follow these steps to deploy the PetaMempawah application to your production server.

## 1. Prepare Server Environment
Ensure your server has:
- PHP 8.2 or higher
- SQLite support (or your preferred database)
- Node.js and NPM (for asset compilation)
- Composer

## 2. Server Configuration
// turbo
1. Clone the repository to your server:
```powershell
git clone <repository-url> .
```
2. Install PHP dependencies:
```powershell
composer install --optimize-autoloader --no-dev
```
3. Copy the environment file and generate the app key:
```powershell
cp .env.example .env
php artisan key:generate
```
4. Create storage symbolic link:
```powershell
php artisan storage:link
```
5. Set correct permissions:
```powershell
chmod -R 775 storage bootstrap/cache
```

## 3. Database & Data Setup
// turbo
1. Run migrations:
```powershell
php artisan migrate --force
```
2. Import village geospatial data:
```powershell
php artisan import:villages
```
3. Create an initial admin user (if not already done):
```powershell
php artisan tinker --execute="App\Models\User::updateOrCreate(['email' => 'admin@admin.com'], ['name' => 'Admin', 'password' => Hash::make('password')])"
```

## 4. Frontend Optimization
// turbo
1. Build assets:
```powershell
npm install
npm run build
```

## 5. Laravel Optimization
// turbo
1. Cache configurations and routes:
```powershell
php artisan config:cache
php artisan route:cache
php artisan view:cache
php artisan filament:cache-components
```

## 6. IDCloudHost Shared Hosting (cPanel) Notes
If you are using Shared Hosting without SSH access:
1. Upload your files via File Manager or FTP.
2. Use the "Terminal" feature in cPanel if available to run the commands above.
3. If "Terminal" is not available, you can use the fallback route `/admin/storage-link` (which we will add) to generate the symlink.
4. Set `APP_URL` in `.env` to your domain (e.g., `https://filammaps.id`).
5. Ensure the `public` folder content is mapped correctly. If your host requires `public_html` as the root, you may need to move files from `public/` to `public_html/` and update `index.php`.

## 7. Post-Deployment
- Ensure `APP_DEBUG=false` in your `.env`.
- Ensure `APP_URL` is set to your production domain.
- Set up a cron job for Laravel's scheduler:
```bash
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```
