<?php

namespace App\Console\Commands;

use App\Models\Village;
use App\Models\SubDistrict;
use App\Models\District;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class ImportVillageData extends Command
{
    protected $signature = 'import:villages';
    protected $description = 'Import village polygons from GeoJSON';

    public function handle()
    {
        $path = public_path('batas-desa.json');
        if (!File::exists($path)) {
            $this->error("File not found: $path");
            return;
        }

        $json = json_decode(File::get($path), true);
        $features = $json['features'] ?? [];

        $this->info("Found " . count($features) . " features.");

        // Ensure we have a default district for now if none exists
        $district = District::firstOrCreate(['name' => 'Mempawah']);

        foreach ($features as $feature) {
            $props = $feature['properties'];
            $name = $props['Nama'] ?? null;
            $kecamatanName = $props['Kecamatan'] ?? null;
            $geometry = json_encode($feature['geometry']);

            if (!$name || !$kecamatanName)
                continue;

            $subDistrict = SubDistrict::firstOrCreate([
                'name' => $kecamatanName,
                'district_id' => $district->id
            ]);

            $village = Village::updateOrCreate(
                ['name' => $name, 'sub_district_id' => $subDistrict->id],
                ['coordinates' => $geometry]
            );

            $this->info("Imported/Updated: $name ($kecamatanName)");
        }

        $this->info("Import completed!");
    }
}
