<?php

namespace App\Filament\Resources\Roads\Tables;

use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Actions\EditAction;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class RoadsTable
{
    public static function configure(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('village.name')
                    ->label('Village')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('name')
                    ->searchable(),
                TextColumn::make('latestDetail.length_meters')
                    ->label('Last Length (m)')
                    ->numeric()
                    ->sortable(),
                TextColumn::make('latestDetail.condition')
                    ->label('Last Condition')
                    ->searchable(),
                TextColumn::make('latestDetail.year_data')
                    ->label('Last Year')
                    ->numeric(thousandsSeparator: '')
                    ->sortable(),
                ImageColumn::make('latestDetail.photo_path')
                    ->label('Last Photo'),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
