<?php

namespace App\Filament\Resources\StuntingAreas\Schemas;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Schemas\Schema;

class StuntingAreaForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->required(),
                Textarea::make('coordinates')
                    ->required()
                    ->columnSpanFull(),
                TextInput::make('risk_level')
                    ->required(),
                TextInput::make('year_data')
                    ->required()
                    ->numeric(),
                FileUpload::make('photo_path')
                    ->directory('stunting-areas')
                    ->image(),
            ]);
    }
}
