<?php

namespace App\Filament\Resources\Stuntings\RelationManagers;

use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Filament\Actions\CreateAction;
use Filament\Actions\EditAction;
use Filament\Actions\DeleteAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;

class DetailsRelationManager extends RelationManager
{
    protected static string $relationship = 'details';

    public function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('year')
                    ->numeric()
                    ->required(),
                TextInput::make('measured_infants')
                    ->label('Bayi Diukur')
                    ->numeric()
                    ->required(),
                TextInput::make('stunted_infants')
                    ->label('Bayi Stunting')
                    ->numeric()
                    ->required()
                    ->live()
                    ->afterStateUpdated(function ($state, $get, $set) {
                        $measured = $get('measured_infants');
                        if ($measured > 0) {
                            $set('percentage', round(($state / $measured) * 100, 2));
                        }
                    }),
                TextInput::make('percentage')
                    ->label('Persentase')
                    ->numeric()
                    ->required(),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('year')
            ->columns([
                TextColumn::make('year')
                    ->sortable(),
                TextColumn::make('measured_infants')
                    ->label('Diukur'),
                TextColumn::make('stunted_infants')
                    ->label('Stunting'),
                TextColumn::make('percentage')
                    ->suffix('%')
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                CreateAction::make(),
            ])
            ->recordActions([
                EditAction::make(),
                DeleteAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }
}
