<?php

namespace App\Filament\Resources\Stuntings;

use App\Filament\Resources\Stuntings\Pages\CreateStunting;
use App\Filament\Resources\Stuntings\Pages\EditStunting;
use App\Filament\Resources\Stuntings\Pages\ListStuntings;
use App\Filament\Resources\Stuntings\RelationManagers\DetailsRelationManager;
use App\Models\Stunting;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use Filament\Resources\Resource;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Filament\Actions\EditAction;
use Filament\Actions\BulkActionGroup;
use Filament\Actions\DeleteBulkAction;
use Filament\Support\Icons\Heroicon;
use Filament\Support\Icons\Icon;
use BackedEnum;
use UnitEnum;

class StuntingResource extends Resource
{
    protected static ?string $model = Stunting::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedShieldExclamation;

    protected static string|UnitEnum|null $navigationGroup = 'Data Kesehatan';

    public static function form(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('village_id')
                    ->relationship('village', 'name')
                    ->required()
                    ->searchable(),
                TextInput::make('name')
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('village.name')
                    ->label('Desa')
                    ->sortable()
                    ->searchable(),
                TextColumn::make('name')
                    ->label('Nama Record')
                    ->searchable(),
                TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->recordActions([
                EditAction::make(),
            ])
            ->toolbarActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            DetailsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListStuntings::route('/'),
            'create' => CreateStunting::route('/create'),
            'edit' => EditStunting::route('/{record}/edit'),
        ];
    }
}
