<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Location;
use App\Models\Road;
use App\Models\Village;
use App\Models\Stunting;
use Illuminate\Http\Request;

class MapController extends Controller
{
    public function locations()
    {
        $locations = Location::with('latestDetail')->get()->map(function ($location) {
            return [
                'id' => $location->id,
                'name' => $location->name,
                'type' => $location->type,
                'latitude' => $location->latitude,
                'longitude' => $location->longitude,
                'year_data' => $location->latestDetail?->year_data,
                'building_condition' => $location->latestDetail?->building_condition,
                'number_of_students' => $location->latestDetail?->number_of_students,
                'photo_path' => $location->latestDetail?->photo_path,
                'village_id' => $location->village_id,
            ];
        });
        return response()->json($locations);
    }

    public function roads()
    {
        $roads = Road::with('latestDetail')->get()->map(function ($road) {
            return [
                'id' => $road->id,
                'name' => $road->name,
                'coordinates' => $road->coordinates,
                'length_meters' => $road->latestDetail?->length_meters,
                'condition' => $road->latestDetail?->condition,
                'year_data' => $road->latestDetail?->year_data,
                'photo_path' => $road->latestDetail?->photo_path,
                'village_id' => $road->village_id,
            ];
        });
        return response()->json($roads);
    }

    public function villages()
    {
        $villages = Village::with(['stuntings.details'])->whereNotNull('coordinates')->get()->map(function ($village) {
            $latestStunting = $village->stuntings->first();
            $latestDetail = $latestStunting?->details->sortByDesc('year')->first();

            return [
                'id' => $village->id,
                'name' => $village->name,
                'coordinates' => $village->coordinates,
                'stunting' => $latestStunting ? [
                    'name' => $latestStunting->name,
                    'latest_detail' => $latestDetail ? [
                        'year' => $latestDetail->year,
                        'measured' => $latestDetail->measured_infants,
                        'stunted' => $latestDetail->stunted_infants,
                        'percentage' => $latestDetail->percentage,
                    ] : null,
                ] : null,
            ];
        });
        return response()->json($villages);
    }
}
