<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Location extends Model
{
    protected $guarded = [];

    public function village(): BelongsTo
    {
        return $this->belongsTo(Village::class);
    }

    public function details(): HasMany
    {
        return $this->hasMany(LocationDetail::class);
    }

    public function latestDetail()
    {
        return $this->hasOne(LocationDetail::class)->latestOfMany();
    }
}
