<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Village extends Model
{
    protected $guarded = [];

    public function subDistrict(): BelongsTo
    {
        return $this->belongsTo(SubDistrict::class);
    }

    public function locations(): HasMany
    {
        return $this->hasMany(Location::class);
    }

    public function roads(): HasMany
    {
        return $this->hasMany(Road::class);
    }

    public function stuntings(): HasMany
    {
        return $this->hasMany(Stunting::class);
    }
}
