<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stunting_areas', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->longText('coordinates'); // JSON array of [lat, lng] for polygon
            $table->string('risk_level');
            $table->integer('year_data');
            $table->string('photo_path')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stunting_areas');
    }
};
