<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('road_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('road_id')->constrained()->onDelete('cascade');
            $table->integer('year_data');
            $table->float('length_meters');
            $table->string('condition');
            $table->string('photo_path')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('road_details');
    }
};
