<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('stunting_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('stunting_id')->constrained()->onDelete('cascade');
            $table->integer('year');
            $table->integer('measured_infants')->comment('bayi yang diukur');
            $table->integer('stunted_infants')->comment('bayi stunting');
            $table->decimal('percentage', 5, 2);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('stunting_details');
    }
};
