<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/map', function () {
    return view('map');
});

// Fallback for storage:link on shared hosting
Route::get('/admin/storage-link', function () {
    // Basic security: only allow in production or if specifically triggered
    // In a real app, this should be protected by auth middleware
    try {
        Artisan::call('storage:link');
        return "The [public/storage] directory has been linked.";
    } catch (\Exception $e) {
        Log::error("Failed to create storage link: " . $e->getMessage());
        return "Failed to create storage link. Check logs for details.";
    }
})->middleware(['web']); // Add 'auth' here if you want it protected by Filament login
